/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.dialogs;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.js.debug.ui.internal.dialogs.Messages;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class HttpServerPathDialog
extends StatusDialog {
    private static final Pattern SERVER_PATH_PATTERN = Pattern.compile("(/[a-zA-Z0-9_!~*'().;?:@&=+$,%#-]+)*/?");
    private String serverPath = "";
    private IResource resource;

    public HttpServerPathDialog(Shell parent, String title) {
        super(parent);
        this.setTitle(title);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        ((GridLayout)container.getLayout()).numColumns = 3;
        Label label = new Label(container, 0);
        label.setText(Messages.HttpServerPathDialog_ServerPath);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        Text serverPathText = new Text(container, 2048);
        serverPathText.setText(this.serverPath);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(250, -1).applyTo((Control)serverPathText);
        label = new Label(container, 0);
        label.setText(Messages.HttpServerPathDialog_WorkspaceLocation);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        final Text workspacePathText = new Text(container, 2056);
        if (this.resource != null) {
            workspacePathText.setText(this.resource.getFullPath().toPortableString());
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)workspacePathText);
        Button browseButton = new Button(container, 8);
        browseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        GridDataFactory.fillDefaults().applyTo((Control)browseButton);
        serverPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpServerPathDialog.this.serverPath = ((Text)e.widget).getText();
                HttpServerPathDialog.this.checkValues();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(HttpServerPathDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof IContainer;
                    }
                });
                dialog.setMessage(Messages.HttpServerPathDialog_SelectWorkspaceFolder);
                if (HttpServerPathDialog.this.resource != null) {
                    dialog.setInitialSelection((Object)HttpServerPathDialog.this.resource);
                }
                if (dialog.open() == 0) {
                    HttpServerPathDialog.this.resource = (IResource)dialog.getFirstResult();
                    workspacePathText.setText(HttpServerPathDialog.this.resource.getFullPath().toPortableString());
                    HttpServerPathDialog.this.checkValues();
                }
            }
        });
        this.updateButtonsEnableState((IStatus)new StatusInfo(4, ""));
        return container;
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.serverPath.length() == 0 || !SERVER_PATH_PATTERN.matcher(this.serverPath).matches()) {
            status.setError(Messages.HttpServerPathDialog_Error_IncompleteServerPath);
        } else if (this.resource == null) {
            status.setError(Messages.HttpServerPathDialog_Error_EmptyWorkspaceLocation);
        }
        this.updateStatus((IStatus)status);
    }

    public IResource getWorkspaceResource() {
        return this.resource;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setWorkspaceResource(IResource resource) {
        this.resource = resource;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }
}

